/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.behaviour.plants;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.math.Vector2;
import technology.rocketjump.undermount.entities.components.BehaviourComponent;
import technology.rocketjump.undermount.entities.components.SteeringComponent;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpecies;
import technology.rocketjump.undermount.environment.model.Season;
import technology.rocketjump.undermount.gamecontext.GameContext;
import technology.rocketjump.undermount.mapping.model.TiledMap;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.mapping.tile.TileNeighbours;
import technology.rocketjump.undermount.messaging.types.EntityMessage;
import technology.rocketjump.undermount.messaging.types.PlantSeedDispersedMessage;

public class ShrubBehaviour
implements BehaviourComponent {
    private static final double HOURS_PER_FRUIT_STATE = 12.0;
    public static final float MIN_SUNLIGHT_FOR_GROWING = 0.8f;
    private static final int MAX_NEIGHBOURS_ALLOWED = 2;
    private MessageDispatcher messageDispatcher;
    private Entity parentEntity;
    private Double lastUpdateGameTime;
    private final double AVG_TIME_TO_SHED_LEAVES_IN_GAME_HOURS = 24.0;
    private final double AVG_TIME_TO_GROW_IN_GAME_HOURS = 12.0;

    @Override
    public void init(Entity parentEntity, MessageDispatcher messageDispatcher, TiledMap areaMap) {
        this.messageDispatcher = messageDispatcher;
        this.parentEntity = parentEntity;
    }

    @Override
    public ShrubBehaviour clone(MessageDispatcher messageDispatcher, TiledMap tiledMap) {
        ShrubBehaviour cloned = new ShrubBehaviour();
        cloned.init(this.parentEntity, messageDispatcher, tiledMap);
        return cloned;
    }

    @Override
    public void update(float deltaTime, TiledMap areaMap) {
    }

    @Override
    public void infrequentUpdate(GameContext gameContext) {
        if (this.lastUpdateGameTime == null) {
            this.lastUpdateGameTime = gameContext.getGameClock().getCurrentGameTime();
        }
        PlantEntityAttributes attributes = (PlantEntityAttributes)this.parentEntity.getPhysicalEntityComponent().getAttributes();
        PlantSpecies species = attributes.getSpecies();
        Season currentSeason = gameContext.getAreaMap().getEnvironment().getCurrentSeason();
        double currentGameTime = gameContext.getGameClock().getCurrentGameTime();
        double elapsedGameHours = currentGameTime - this.lastUpdateGameTime;
        this.lastUpdateGameTime = currentGameTime;
        if (gameContext.getAreaMap().getEnvironment().getSunlightAmount() > 0.8f) {
            float extraGrowth = (float)(elapsedGameHours / 12.0 * (double)attributes.getGrowthRate());
            float currentGrowthAmount = attributes.getGrowthAmount();
            if ((currentGrowthAmount += extraGrowth) > 1.0f) {
                if (attributes.isFullyGrown()) {
                    if (!species.hasFruit()) {
                        this.checkForCompetition(gameContext.getAreaMap());
                        this.messageDispatcher.dispatchMessage(321, new PlantSeedDispersedMessage(species, this.parentEntity.getLocationComponent().getWorldPosition()));
                    }
                } else {
                    attributes.setFullyGrown(true);
                }
                currentGrowthAmount = 0.0f;
            }
            attributes.setGrowthAmount(currentGrowthAmount);
            if (species.hasFruit()) {
                if (species.getFruit().getGrowingSeasons().contains((Object)currentSeason) && attributes.isFullyGrown()) {
                    float fruitGrowthAmount = attributes.getFruitGrowthAmount();
                    if ((fruitGrowthAmount = (float)((double)fruitGrowthAmount + elapsedGameHours / 12.0 * (double)attributes.getGrowthRate())) > 1.0f) {
                        fruitGrowthAmount = 0.0f;
                        attributes.setFruitState(attributes.getFruitState().getNext());
                        if (attributes.getFruitState().equals((Object)PlantEntityAttributes.FruitState.BARE)) {
                            this.messageDispatcher.dispatchMessage(320, new PlantSeedDispersedMessage(species, this.parentEntity.getLocationComponent().getWorldPosition()));
                        }
                    }
                    attributes.setFruitStateProgress(fruitGrowthAmount);
                    Color newColor = new Color();
                    switch (attributes.getFruitState()) {
                        case BARE: {
                            newColor.a = 0.0f;
                            break;
                        }
                        case BUDDING: {
                            newColor = species.getLeafColors().first().cpy();
                            newColor.a = fruitGrowthAmount;
                            break;
                        }
                        case RIPENING: {
                            Color unripeColor = species.getLeafColors().first().cpy();
                            Color ripeColor = species.getFruit().getColor().cpy();
                            newColor = unripeColor.mul(1.0f - fruitGrowthAmount).add(ripeColor.mul(fruitGrowthAmount));
                            break;
                        }
                        case RIPE: {
                            newColor = species.getFruit().getColor().cpy();
                        }
                    }
                    attributes.setActualFruitColor(newColor);
                } else {
                    attributes.setFruitState(PlantEntityAttributes.FruitState.BARE);
                }
            }
        }
    }

    private void checkForCompetition(TiledMap areaMap) {
        Vector2 worldPosition = this.parentEntity.getLocationComponent().getWorldPosition();
        GridPoint2 tilePosition = new GridPoint2((int)Math.floor(worldPosition.x), (int)Math.floor(worldPosition.y));
        TileNeighbours tileNeighbours = areaMap.getNeighbours(tilePosition.x, tilePosition.y);
        int numNeighbouring = 0;
        for (MapTile neighbourTile : tileNeighbours.values()) {
            if (!neighbourTile.hasTree() && !neighbourTile.hasShrub()) continue;
            ++numNeighbouring;
        }
        if (numNeighbouring > 2) {
            this.messageDispatcher.dispatchMessage(322, new EntityMessage(this.parentEntity.getId()));
        }
    }

    @Override
    public SteeringComponent getSteeringComponent() {
        return null;
    }

    @Override
    public boolean isUpdateEveryFrame() {
        return false;
    }

    @Override
    public boolean isUpdateInfrequently() {
        return true;
    }

    @Override
    public boolean isJobAssignable() {
        return false;
    }
}

